/*
 * Decompiled with CFR 0.152.
 */
package OreSpawn.entities;

import OreSpawn.OreSpawnMain;
import OreSpawn.entities.JumpyBug;
import OreSpawn.entities.ThrownAcid;
import dangerzone.Player;
import dangerzone.TextureMapper;
import dangerzone.Utils;
import dangerzone.World;
import dangerzone.entities.Entity;
import dangerzone.entities.EntityLiving;
import dangerzone.items.Items;
import org.newdawn.slick.opengl.Texture;

public class SpitBug
extends EntityLiving {
    public SpitBug(World w) {
        super(w);
        this.maxrenderdist = 150;
        this.height = 2.73f;
        this.width = 2.75f;
        this.uniquename = "OreSpawn:SpitBug";
        this.moveSpeed = 0.21f;
        this.setMaxHealth(80.0f);
        this.setHealth(80.0f);
        this.setDefense(1.0f);
        this.setAttackDamage(5.0f);
        this.searchDistance = 30.0f;
        this.attackRange = 2.0f;
        this.movefrequency = 65;
        this.setExperience(79);
        this.canSwim = true;
        this.temperament = 1;
        this.enable_hostile = true;
        this.daytimespawn = false;
        this.daytimedespawn = true;
        this.nighttimespawn = true;
        this.nighttimedespawn = false;
        this.tower_defense_enable = true;
    }

    public void doDistanceAttack(Entity victim) {
        if (this.world.isServer) {
            ThrownAcid e = (ThrownAcid)this.world.createEntityByName("OreSpawn:ThrownAcid", this.dimension, this.posx + (double)((float)Math.sin(Math.toRadians(this.rotation_yaw_head)) * (this.width / 2.0f) * (float)Math.cos(Math.toRadians(this.rotation_pitch_head))), this.posy + (double)(this.getHeight() * 3.0f / 5.0f) - (double)((float)Math.sin(Math.toRadians(this.rotation_pitch_head)) * (this.width / 2.0f)), this.posz + (double)((float)Math.cos(Math.toRadians(this.rotation_yaw_head)) * (this.width / 2.0f) * (float)Math.cos(Math.toRadians(this.rotation_pitch_head))));
            if (e != null) {
                e.init();
                e.setBID(0);
                e.setIID(OreSpawnMain.acid.itemID);
                e.thrower = this;
                e.setDirectionAndVelocity((float)Math.sin(Math.toRadians(this.rotation_yaw_head)) * (float)Math.cos(Math.toRadians(this.rotation_pitch_head)), -((float)Math.sin(Math.toRadians(this.rotation_pitch_head))), (float)Math.cos(Math.toRadians(this.rotation_yaw_head)) * (float)Math.cos(Math.toRadians(this.rotation_pitch_head)), 4.5f, 0.2f);
                this.world.spawnEntityInWorld((Entity)e);
            }
            this.world.playSound("DangerZone:bow", this.dimension, this.posx, this.posy + (double)this.getHeight(), this.posz, 0.5f, 1.0f + (this.world.rand.nextFloat() - this.world.rand.nextFloat()) * 0.3f);
        }
    }

    public String getLivingSound() {
        if (this.world.rand.nextBoolean()) {
            return null;
        }
        if (this.world.rand.nextBoolean()) {
            return "OreSpawn:clatter1";
        }
        return "OreSpawn:clatter2";
    }

    public String getHurtSound() {
        return "OreSpawn:crunch";
    }

    public String getDeathSound() {
        return "OreSpawn:emperorscorpion_death";
    }

    public void doDeathDrops() {
        int howmany = 4 + this.world.rand.nextInt(5);
        howmany = 3 + this.world.rand.nextInt(5);
        int i = 0;
        while (i < howmany) {
            Utils.doDropRand((World)this.world, (int)0, (int)Items.lumpcopper.itemID, (float)4.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
            ++i;
        }
        if (this.world.rand.nextInt(10) == 1) {
            Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.trophyspitbug.itemID, (float)1.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
        }
        super.doDeathDrops();
    }

    public boolean isSuitableTarget(Entity e) {
        if (this.isIgnorable(e)) {
            return false;
        }
        if (e instanceof SpitBug) {
            return false;
        }
        if (e instanceof JumpyBug) {
            return false;
        }
        if (e.temperament == 1 && this.CanProbablySeeEntity(e)) {
            return true;
        }
        return e instanceof Player && this.CanProbablySeeEntity(e);
    }

    public Texture getTexture() {
        if (this.texture == null) {
            this.texture = TextureMapper.getTexture((String)"orespawnres/skins/SpitBugtexture.png");
        }
        return this.texture;
    }
}

